/*********************************************************************
 * INCLUDES
 *//*
#include <xdc/runtime/Error.h>

#include <ti/sysbios/family/arm/cc26xx/Power.h>
#include <ti/sysbios/BIOS.h>

#include "ICall.h"
#include "bcomdef.h"
#include "peripheral.h"
#include "simpleBLEPeripheral.h"
#include "tempSensor.h"
#include <stdio.h>

// Header files required to enable instruction fetch cache
#include <inc/hw_memmap.h>
#include <driverlib/vims.h>

#include "Board.h"
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/family/arm/m3/Hwi.h>

#include <ti/drivers/PIN/PINCC26XX.h>

#include <driverlib/aux_adc.h>
#include <driverlib/aux_wuc.h>
#include <inc/hw_aux_evctl.h>

#define TASK_STACK_SIZE 512
#define TASK_PRI        0


char taskStack[TASK_STACK_SIZE];
Task_Struct taskStruct;

Semaphore_Struct tempsem;
Semaphore_Handle htempsem;

Hwi_Struct hwi;

#define SAMPLECOUNT 8
#define SAMPLETYPE uint16_t
#define SAMPLESIZE sizeof(SAMPLETYPE)

//const PIN_Config temp_config_table[] = {
//		Board_LED1 		| PIN_GPIO_OUTPUT_EN | PIN_GPIO_HIGH | PIN_PUSHPULL | PIN_DRVSTR_MAX,
//		Board_LED2 		| PIN_GPIO_OUTPUT_EN | PIN_GPIO_HIGH | PIN_PUSHPULL | PIN_DRVSTR_MAX,
//		Board_LED3 		| PIN_GPIO_OUTPUT_EN | PIN_GPIO_HIGH | PIN_PUSHPULL | PIN_DRVSTR_MAX,
//		Board_TEMP_SENS  | PIN_INPUT_DIS	  | PIN_GPIO_OUTPUT_DIS 	  | PIN_NOPULL,    			 //Temp Sensor configured as input and floating
//		PIN_TERMINATE
//};

PIN_Handle pinHandle;
PIN_State  pinState;
SAMPLETYPE adcSamples[SAMPLECOUNT];
SAMPLETYPE singleSample;

int j = 0;
double led_blink_time = 0;
double sample_avg = 0;
double sample_sum = 0;

void tempTaskFxn(UArg a0, UArg a1);
void adcIsr(UArg a0);

void tempSensor_createTask(void){
    //Initialize task
    Task_Params params;
    Task_Params_init(&params);
    params.priority = TASK_PRI;
    params.stackSize = TASK_STACK_SIZE;
    params.stack = taskStack;

    Task_construct(&taskStruct, tempTaskFxn, &params, NULL);
}

tempTask_init(){
	
    // Construct semaphore used for pending in task
    Semaphore_Params sParams;
    Semaphore_Params_init(&sParams);
    sParams.mode = Semaphore_Mode_BINARY;

    Semaphore_construct(&tempsem, 0, &sParams);
    htempsem = Semaphore_handle(&tempsem);
	
	Hwi_Params hwiParams;
	Hwi_Params_init(&hwiParams);
	hwiParams.enableInt = true;

	Hwi_construct(&hwi, INT_AUX_ADC, adcIsr, &hwiParams, NULL);
}


void tempTaskFxn(UArg a0, UArg a1) {

	tempTask_init();
	
	for(;;)
	{
		// Set up pins
		pinHandle = PIN_open(&pinState, BoardGpioInitTable);
		// Enable clock for ADC digital and analog interface (not currently enabled in driver)
		AUXWUCClockEnable(AUX_WUC_MODCLKEN0_ANAIF_M|AUX_WUC_MODCLKEN0_AUX_ADI4_M);
		// Connect AUX IO7 (DIO23) as analog input. Light sensor on SmartRF06EB
		AUXADCSelectInput(ADC_COMPB_IN_AUXIO5);

		// Set up ADC
		AUXADCEnableSync(AUXADC_REF_FIXED, AUXADC_SAMPLE_TIME_2P7_US, AUXADC_TRIGGER_MANUAL);

		// Disallow STANDBY mode while using the ADC.
		//Power_setConstraint(Power_SB_DISALLOW);

		uint8_t currentSample = 0;

		while(currentSample < SAMPLECOUNT) {
			//Sleep 100ms in IDLE mode
			Task_sleep(100 * 1000 / Clock_tickPeriod);

			// Trigger ADC sampling
			AUXADCGenManualTrigger();
			// Wait in IDLE until done
			Semaphore_pend(htempsem, BIOS_WAIT_FOREVER );

			adcSamples[currentSample++] = singleSample;
		}

		// Disable ADC
		AUXADCDisable();
		// Allow STANDBY mode again
		//Power_releaseConstraint(Power_SB_DISALLOW);

		sample_sum = 0;
		for(j = 0; j < SAMPLECOUNT; j++)
		{
			sample_sum += adcSamples[j];
		}
		sample_avg = sample_sum / SAMPLECOUNT;

		// Log data through LED
		led_blink_time = sample_avg/100;
		for(j = 0; j < led_blink_time; j++)
		{
			PIN_setOutputValue(pinHandle, Board_LED3, 0);
			Task_sleep(0.3 * 100000); //Pause for 0.3 second
			PIN_setOutputValue(pinHandle, Board_LED3, 1);
			Task_sleep(0.3 * 100000); //Pause for 0.3 second
		}

		// Restore pins to values in BoardGpioTable
		PIN_close(pinHandle);

		// Log data through UART
		// for(uint8_t i = 0; i<SAMPLECOUNT; i++ ) {
		// UART_write(uHandle, &adcSamples[i], SAMPLESIZE);

		// Goto STANDBY forever
		//Task_sleep(BIOS_WAIT_FOREVER);

		Task_sleep(30 * 100000); //Pause for 30 second
	}
}

void adcIsr(UArg a0) {

    // Pop sample from FIFO to allow clearing ADC_IRQ event
    singleSample = AUXADCReadFifo();
    // Clear ADC_IRQ flag. Note: Missing driver for this.
    HWREGBITW(AUX_EVCTL_BASE + AUX_EVCTL_O_EVTOMCUFLAGSCLR, AUX_EVCTL_EVTOMCUFLAGSCLR_ADC_IRQ_BITN) = 1;

    // Post semaphore to wakeup task
    Semaphore_post(htempsem);

}
*/
